﻿/*
USAGE:
	#include "gameProgram/loadgame.as"
	loadGame( "gameName" );
*/
var restoreData = function( loadedData ){
	var define_swf;
	#include "gameFunctions/copyObject.as"
	#include "gameProgram/rpgScripts/swf.as"
	
	var result = false;
	if(loadedData)
	{// if:  there's data to load
		// remove game_mc		(reset SWF storage BEFORE loading a new one)
		ROOT.game_mc.removeMovieClip();
		
		
		// clear previous SWF's
		HUD.removeAll();
		var removeSwf = function( swfCommand )
		{
			var command_obj = {};
			// populate command_obj
			command_obj.data = {};
			copyObject( swfCommand, command_obj.data );
			command_obj.data.linkage = null;		// Indicate that this SWF should be removed
			var startTime = 0;		// disable the command's 1ms wait fail-safe
			// run command_obj
			define_swf( command_obj, run );
		}// removeSwf()
		if(RAM.swfLoader.permSwf==undefined)
			trace("WARNING:  RAM.swfLoader.permSwf is missing!");
		if(RAM.swfLoader.permSwf)
			for(var s=RAM.swfLoader.permSwf.length-1; s>=0; s--)
				removeSwf( RAM.swfLoader.permSwf[s] );
		// temporary SWF's will be cleared by loadLevel()
		
		
		// delete current RAM
		var deleteAllData = function( thisObject )
		{
			for(var nam in thisObject)
			{
				if(typeof(thisObject[nam]) == "object"){
					deleteAllData( thisObject[nam] );		// delete contents
					thisObject[nam] = null;		delete thisObject[nam];		// delete the container
				 }else{
					 thisObject[nam] = null;	delete thisObject[nam];		// delete variable
				 }// if:  typeof object
			}// for:  everything in this object
		}// deleteAllData
		deleteAllData( RAM );
		_global.RAM = {};
		
		// copy data to RAM
		copyObject( loadedData, _global.RAM );
		// initialize any missing data		// POKEMON ONLY
		ROOT.completeRam();
		


		// detect if there's anything in the loaded data
		for(var nam in _global.RAM){
			result = true;
			break;
		}
		
		// restore audio settings
		if(RAM.saveSettings.music.isPlaying){
			MUSIC.play( RAM.saveSettings.music.songName );
		}else{
			MUSIC.songName = RAM.saveSettings.music.songName;
			MUSIC.stop();
		}
		MUSIC.volume = RAM.saveSettings.music.volume;
		MUSIC.songVolume = RAM.saveSettings.music.songVolume;
		SOUND.stopAll();
		SOUND.volume = RAM.saveSettings.sound.volume;
		
		
		// manually remove previous sprites
		for(var spriteNam in SPRITES){
			SPRITES[spriteNam].onUnload();
		}// for:  each sprite
		
		
		
		// prepare to leave the current level
		// remove all loops
		LOOP.removeSet( "player" );
		LOOP.removeSet( "scroll" );
		LOOP.removeSet( "sprites" );
		// LOOP.removeSet( "fieldMenu" );		// POKEMON ONLY
		
		// wait for "fade-out"  (even though no transition is occurring)
		// load level
		setTimeout(function(){
			ROOT.loadLevel( RAM.saveSettings.level, RAM.saveSettings.playerPosition )
			// announce "loadGame" after level loads
			// wait for level to load
			.then = function(){
				// wait for main map sprites to populate
				react.once().to("onNewLevel").then = function(){
					// announce that a save-file has finished loading
					ROOT.sendEvent("loadGame", {value: loadedData});
				}// onNewLevel()
			}// after loading a new level
			
		}, 0);
		
		
		
		
		// restore SWF's		(SWF commands will be re-called)		(manual alterations in settings via setVariable are NOT preserved!)
		var restoreSwf = function( swfCommand )
		{
			var command_obj = {};
			// populate command_obj
			command_obj.data = {};
			copyObject( swfCommand, command_obj.data );
			// run "swf" command
			define_swf( command_obj,  true );
		}// restoreSwf()
		
		setTimeout( function()
		{// run after a moment
			for(var s=0; s<RAM.swfLoader.permSwf.length; s++){
				restoreSwf( RAM.swfLoader.permSwf[s] );
			}
			for(var s=0; s<RAM.swfLoader.tempSwf.length; s++){
				restoreSwf( RAM.swfLoader.tempSwf[s] );
			}
		}, 34 );		// run after a moment
		
	}// if:  there's data to load
	return result;
}// restoreData()



var loadGame = function( gameId )
{
	// trace("\n loadGame()");
	var gameId = gameId || "humbird0_rpg";
	gameId = gameId.split(" ").join("_");
	
	// access saved data
	var srm = SharedObject.getLocal(gameId);
	
	// report whether any data was loaded
	var result = false;
	for(var result in srm.data.ram)		break;
	result = Boolean( result );
	
	// overwrite RAM  (if load was successful)
	if(result)
		restoreData( srm.data.ram );
	
	// ROOT.sendEvent("loadGame", {value: srm.data.ram});
	
	return result;
}// loadSave()